using System;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL.VAL.RPC
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Brian    lin</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/24/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides means to retrieve a list of orderable component classes converted to XML.</summary>

	#endregion

	public class ComponentClass : MarshalByRefObject
	{
		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5951"> 
		///		<ExpectedInput>None required</ExpectedInput>
		///		<ExpectedOutput>Non-null valid XML string with 6 ComponentClass elements.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6753"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Method used by the VistA surgery package to retrieve a list of Orderable Component Classes.
		/// </summary>
		/// <returns>XML string containing ComponentClass.ComponentClassName and ComponentClass.ComponentClassShortName values.</returns>
		public string GetComponentClassList()
		{
			return RpcDataReader.GetXmlData(STOREDPROC.VistaGetXmlComponentClass.StoredProcName);
		}
	}
}
